jQuery(document).ready(function($) {
    var isRunning = false;
    var totalLinks = 0;

    $('#btn-auto-process').click(function() {
        if (isRunning) return;
        isRunning = true;

        $(this).prop('disabled', true).text('Running...');
        $('#btn-stop').show();
        $('#cm-progress-wrapper').show();
        $('#cm-log').show().html('<p>🚀 Initializing...</p>');
        updateProgress(0, "Starting Scan...");
        scanLinks();
    });

    $('#btn-stop').click(function() {
        isRunning = false;
        log('🛑 Stopped by user.', 'red');
        resetUI();
    });

    function scanLinks() {
        log('🔍 Scanning database...');
        // 使用 cm_vars.ajax_url 获取地址
        $.post(cm_vars.ajax_url, { action: 'cubemage_scan_links' }).done(function(res) {
            if(res.success) {
                totalLinks = res.data.total;
                log('✅ Scan Complete. Found ' + totalLinks + ' links.');
                if (totalLinks === 0) { finishProcess(); return; }
                log('⏳ Starting verification...', '#4facfe');
                checkBatch();
            } else {
                handleError('Scan Failed: ' + res.data.message);
            }
        }).fail(function() {
            handleError('Server Error.');
        });
    }

    function checkBatch() {
        if (!isRunning) return;
        $.post(cm_vars.ajax_url, { action: 'cubemage_check_status' }).done(function(res) {
            if(res.success) {
                var done = totalLinks - res.data.remaining;
                var percent = Math.floor((done / totalLinks) * 100);
                log('👉 ' + res.data.message);
                updateProgress(percent, "Checking... " + done + "/" + totalLinks);

                if (res.data.email_result !== null) {
                    if (res.data.email_result === true) log('<strong style="color:#00ff00;">📧 Email report sent!</strong>');
                    else log('<strong style="color:orange;">⚠️ Email failed. Check SMTP.</strong>');
                }

                if (res.data.remaining > 0) checkBatch();
                else finishProcess();
            } else {
                handleError('Check Failed: ' + res.data.message);
            }
        }).fail(function() {
            handleError('Server connection lost.');
        });
    }

    function finishProcess() {
        updateProgress(100, "Completed!");
        log('🎉 <strong>Done!</strong>', 'green');
        var refreshBtn = '<button onclick="location.reload()" class="button button-primary" style="margin-top:10px;">🔄 Refresh Page</button>';
        $('#cm-log').append('<p>' + refreshBtn + '</p>').scrollTop(9999);
        $('#btn-auto-process').text('Process Completed');
        $('#btn-stop').hide();
        isRunning = false;
    }

    function handleError(msg) {
        isRunning = false;
        log('❌ ' + msg, 'red');
        resetUI();
    }

    function resetUI() {
        $('#btn-auto-process').prop('disabled', false).text('Start Full Scan & Check');
        $('#btn-stop').hide();
    }

    function updateProgress(percent, text) {
        $('#cm-progress-bar').css('width', percent + '%');
        $('#cm-progress-percent').text(percent + '%');
        $('#cm-progress-text').text(text);
    }

    function log(msg, color) {
        var style = color ? 'style="color:' + color + '"' : '';
        $('#cm-log').append('<p ' + style + '>' + msg + '</p>').scrollTop(9999);
    }
});